

import { ContractTaskPopup } from '../ContractTaskPopup.js';


export class ContractTaskListWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.exportTasks" class="fa fa-file-export"></a>
			</div>
			
			<h1>Overzicht Contract Taken</h1>
		</div>
		
		<form id="frmContractTasks" method="get">
			<div class="chk-search-status">
				<ez-checkbox name="st_o" label="Open" value="open"></ez-checkbox>
				<ez-checkbox name="st_ip" label="In behandeling" value="inprogress"></ez-checkbox>
				<ez-checkbox name="st_d" label="Voltooid" value="done"></ez-checkbox>
				<ez-checkbox name="upcoming" label="Opkomende alerts" value="upcoming"></ez-checkbox>
			</div>
			
			<div class="clear"></div>
			
			<input type="text" name="q" placeholder="Zoek: klant, contractnaam, ...." />
		</form>
		
		
		<div id="ctresults" ez-subtemplate="ctresults">
			<table class="table">
				<thead>
					<tr>
						<th style="width: 100px;">Contract #</td>
						<th>Contract</td>
						<th>Relatie</th>
						<th>Taak omschrijving</td>
						<th>Alert datum</td>
						<th>Status</td>
					</tr>
				</thead>
				
				<tbody ez-for="tasks" ez-item="t">
					<tr class="tr-task pointer" data-contract-task-id="{{ t.contract_task_id }}" [contract-task]="t">
						<td>{{ t.contract_id }}</td>
						<td>{{ t.contract_name }}</td>
						<td>{{ t.customer_name ?? '' }}</td>
						<td>{{ t.description }}</td>
						<td>{{ format_date(str2date(t.next_alert_date), {dmy: true}) }}</td>
						<td>
							{{ _(t.next_status) }}
						</td>
					</tr>
				</tbody>
				<tbody ez-if="tasks == null">
					<tr>
						<td colspan="6" class="no-results">Loading...</td>
					</tr>
				</tbody>
				<tbody ez-if="tasks != null && tasks.length == 0">
					<tr>
						<td colspan="6" class="no-results">Geen resultaten gevonden</td>
					</tr>
				</tbody>
			</table>
			
			<ez-pager></ez-pager>
		</div>
		
	`;
	
	pageNo = 0;
	
	container;
	ezTpl = null;
	tasks = null;
	response = null;
	
	
	
	init(container) {
		this.container = container;
		
		this.render();
		
		this.loadState();
	}
	
	render() {
		if (!this.ezTpl) {
			this.ezTpl = new EzTemplate( this.container );
			this.ezTpl.setVar('tasks', this.tasks);
			this.ezTpl.setObject('widget', this);
			this.ezTpl.loadHtml( this.tpl );
			this.ezTpl.render();
			
			$('#frmContractTasks').find('input[type=checkbox], input[type=text]').on('change', function() {
				this.pageNo = 0;
				this.loadTasks();
			}.bind(this));
			
			$('#frmContractTasks').find('input[type=checkbox]').on('change', function() {
				this.saveStatusState();
			}.bind(this));
			
		}
		else {
			let r = $(this.container).find('#ctresults');
			let tpl = r.get(0).eztemplate;
			tpl.setVar('tasks', this.tasks);
			tpl.setVar('response', this.response);
			tpl.render();
			
			
			$('#ctresults tr.tr-task').on('click', function( evt ) {
				let target = evt.target;
				if ($(target).hasClass('.actions') || $(target).closest('td.actions').length > 0)
					return;
				
				let tr = $(evt.target).closest('tr');
				let ctid = tr.data('contract-task-id');
				
				
				this.popupTask( ctid );
				
			}.bind(this));
		}
	}
	
	saveTaskStatus( contractTaskId, newStatus ) {
		let tr = $('tr[data-contract-task-id=' + contractTaskId + ']');
		
		tr.find('img.loading-indicator').show();
		
		postUrl( '/service/contracts/task.do', {
			a: 'updateTaskStatus',
			contractTaskId: contractTaskId,
			status: newStatus
		}).then(async function(e) {
			let json = await e.json();
			tr.find('img.loading-indicator').hide();
			
			reportUserMessage( 'Wijziging opgeslagen' );
		}.bind(this));
	}
	
	
	saveStatusState() {
		let s = {};
		s.status_open       = $('input[name=st_o]').prop('checked')  ? 1 : 0;
		s.status_inprogress = $('input[name=st_ip]').prop('checked') ? 1 : 0;
		s.status_done       = $('input[name=st_d]').prop('checked')  ? 1 : 0;
		s.show_upcoming     = $('input[name=upcoming]').prop('checked')  ? 1 : 0;
		
		
		postUrl( '/service/state.do', {
			a: 'save',
			name: 'contract-tasklist-settings',
			key: '1',
			data: JSON.stringify( s )
		});
	}
	
	
	loadState() {
		postUrl( '/service/state.do', {
			a: 'load',
			name: 'contract-tasklist-settings',
			key: '1'
		}).then( async function(e) {
			let json = await e.json();
			
			let checkCount = 0;
			if (json && json.success && json.data) {
				let settings = JSON.parse( json.data );
				if (settings) {
					if ( settings.status_open ) {
						$('input[name=st_o]').prop('checked', true);
						checkCount++;
					}
					if ( settings.status_inprogress ) {
						$('input[name=st_ip]').prop('checked', true);
						checkCount++;
					}
					if ( settings.status_done ) {
						$('input[name=st_d]').prop('checked', true);
						checkCount++;
					}
					if ( settings.show_upcoming ) {
						$('input[name=upcoming]').prop('checked', true);
						checkCount++;
					}
				}
			}
//			if (checkCount == 0) {
//				$('.chk-search-status').find('input[name=st_o], input[name=st_ip], input[name=st_d]').prop('checked', true);
//			}
			
			this.loadTasks();
		}.bind(this));
		
	}
	
	
	pageParams() {
		let p = {};
		p.status_open       = $('input[name=st_o]').prop('checked')  ? 1 : 0;
		p.status_inprogress = $('input[name=st_ip]').prop('checked') ? 1 : 0;
		p.status_done       = $('input[name=st_d]').prop('checked')  ? 1 : 0;
		p.upcoming          = $('input[name=upcoming]').prop('checked')  ? 1 : 0;
		p.q                 = $('#frmContractTasks [name=q]').val();
		
		return p;
	}
	
	
	loadTasks() {
		
		let d = this.pageParams();
		d.pageNo = this.pageNo;
		
		d.a = 'searchTasks';
		
		postUrl( '/service/contracts/task.do', d).then(async function(e) {
			let json = await e.json();
			this.tasks = json.tasks;
			this.response = json;
			
			this.render();
		}.bind(this));
		
	}
	
	
	selectPage( pageNo ) {
		this.pageNo = pageNo;
		this.loadTasks();
	}
	
	
	popupTask( contractTaskId ) {
		let tr = $('tr[data-contract-task-id='+contractTaskId+']').get(0);
		
		let ct = tr['contract-task'];
		console.log( ct );
		
		let ctid = ct.contract_task_id;
		
		let ctp = new ContractTaskPopup(ctid);
		ctp.setContractId( ct.contract_id );
//		ctp.setCallbackSave( function(task) {
//			this.loadTasks();
//		}.bind(this));
		
		ctp.setShowGotoContract( true );
		
		let c = ctp.showPopup();
		c.get(0).close_callback = function() {
			this.loadTasks();
		}.bind(this);
	}
	
	
	exportTasks() {
		
		let params = this.pageParams();
		
		let url = '/service/contracts/task.do?a=export';
		
		for(let i in params) {
			url = url + '&' + i + '=' + params[i];
		}
		
		window.location = url;
	}
	
	
}

